/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: $
   Last Modification:
    $Author: Robert $
    $Modtime: $
    $Revision: 7361 $

   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)

   Description:
   cifX API function implementation

   Changes:

     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     2         04.12.2009  SS       - List item definitions added
     1         ?           ?        ?

**************************************************************************************/

#pragma once
#include  "afxcmn.h"
#pragma warning(push)
#pragma   warning( disable :4312 4311 4702)
#include  "TreeListCtrl\TreeListCtrl.h"
#include <map>
#pragma warning(pop)

#include "cifXUser.h"
#include "TCPConnector.h"

#ifndef WIN_64
  #include "resource_x86.h"   // main symbols
#else
  #include "resource_x64.h"   // main symbols
#endif

#define SUBITEM_HOSTNAME   1
#define SUBITEM_RXCOUNT    2
#define SUBITEM_TXCOUNT    3
#define MARSHALLER_REQUEST (WM_USER + 1)
#define IDT_CYCLIC         (WM_USER + 2)
#define IDT_TCPINFO        (WM_USER + 3)

/*****************************************************************************/
/*! \class CcifXTCPServerDlg
 * This is the main dialog class for the TCPServer application               */
/*****************************************************************************/
class CcifXTCPServerDlg : public CDialog
{
// Construction
public:
             CcifXTCPServerDlg    ( CWnd* pParent = NULL);
  TLR_RESULT InitMarshaller       ( void);
  void       DeinitMarshaller     ( void);
// Dialog Data
  enum { IDD = IDD_CIFXTCPSERVER_DIALOG };

// Implementation
protected:
  HICON              m_hIcon;
  CTreeListCtrl      m_cClientListCtrl;
  HTREEITEM          m_hClientItem;
  void*              m_pvMarshaller;

  static  void    MarshallerRequestWrapper(void* pvMarshaller, void* pvUser);


  // Generated message map functions
  virtual void DoDataExchange(CDataExchange* pDX);  // DDX/DDV support
  virtual BOOL OnInitDialog();
  afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
  afx_msg void OnPaint();
  afx_msg HCURSOR OnQueryDragIcon();
  afx_msg void OnTimer(UINT_PTR nIDEvent);
  afx_msg void OnDestroy();
  afx_msg LRESULT OnMarshallerRequest(WPARAM wParam, LPARAM lParam);
  DECLARE_MESSAGE_MAP()

};
